/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.catalogos.PorcentajeRetencion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Retencion;
import ec.gob.sri.dimm.ats.modelo.obj.ValoresComprobante;
import ec.gob.sri.dimm.ats.modelo.obj.compras.FormaPago;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValoresComprobanteVenta
extends ValoresComprobante {
    private static final String RETENCION_IVA_SERVICIOS50 = "retencionIvaServicios50";
    private static final long serialVersionUID = -8731651135743059107L;
    public static final String C_BASE_NO_IVA = "baseNoIva";
    public static final String C_BASE_IVA_NO_CERO = "baseIvaNoCero";
    public static final String C_BASE_EXCENTA_IVA = "baseExcentaIva";
    public static final String C_MONTO_IVA = "montoIva";
    public static final String C_RET_IVA_BIENES = "retencionIvaBienes";
    public static final String C_RET_IVA_SERVICIOS = "retencionIvaServicios";
    public static final String C_RET_IVA_CIEN = "retencionIvaCien";
    public static final String CC_FORMAS_PAGO = "formasPago";
    public static final String RETENCION_IVA_10 = "retencionIva10";
    private static final String RETENCION_IVA_20 = "retencionIva20";
    public static final String C_RET_IVA_NC = "retencionNCIva";
    @NotNull(message="Debe ingresar el valor de No objeto de IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor No objeto de IVA debe ser 12 enteros y 2 decimales. ")
    private String baseNoIva = "0.00";
    @NotNull(message="Debe ingresar el valor de Tarifa IVA diferente de 0%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Tarifa IVA diferente de 0% debe ser 12 enteros y 2 decimales. ")
    private String baseIvaNoCero = "0.00";
    @NotNull(message="Debe ingresar el valor de Base Imponible Exenta de IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Base Imponible Exenta de IVA debe ser 12 enteros y 2 decimales. ")
    private String baseExcentaIva = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto IVA debe ser 12 enteros y 2 decimales. ")
    private String montoIva = "0.00";
    @NotNull(message="Valor retenido IVA 10%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 10% Bienes debe ser 12 enteros y 2 decimales. ")
    private String retencionIva10 = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 20% Servicios debe ser 12 enteros y 2 decimales. ")
    private String retencionIva20 = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 30% Bienes")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 30% Bienes debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaBienes = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 50% Servicios")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 50% Servicios debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaServicios50 = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 70% Servicios")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 70% Servicios debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaServicios = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA 100%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA 100% debe ser 12 enteros y 2 decimales. ")
    private String retencionIvaCien = "0.00";
    @NotNull(message="Debe ingresar el valor de Retenci\u00f3n IVA NC")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Retenci\u00f3n IVA NC debe ser 12 enteros y 2 decimales. ")
    private String retencionNCIva = "0.00";
    private final List<FormaPago> formasPago = new ArrayList<FormaPago>();
    private boolean modificaIva;

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        if (this.validarTotalRetencionMontoIva(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva10(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva20(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva30Bienes(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva50(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIva70Servicios(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIvaCien(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        if (!this.validarRetencionIvaNC(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    @Override
    public ValoresComprobanteVenta crearCopiaEdicion() {
        ValoresComprobanteVenta copia = new ValoresComprobanteVenta();
        copia.setBaseIvaCero(super.getBaseIvaCero());
        copia.setMontoIce(super.getMontoIce());
        copia.setRetencionIvaBienesCalculado(super.getRetencionIvaBienesCalculado());
        copia.setRetencionIvaServiciosCalculado(super.getRetencionIvaServiciosCalculado());
        copia.setRetencionIvaCienCalculado(super.getRetencionIvaCienCalculado());
        copia.setMontoIvaCalculado(super.getMontoIvaCalculado());
        copia.setRetencionIvaNCCalculado(super.getRetencionIvaNCCalculado());
        copia.baseNoIva = this.baseNoIva;
        copia.baseIvaNoCero = this.baseIvaNoCero;
        copia.montoIva = this.montoIva;
        copia.baseExcentaIva = this.baseExcentaIva;
        copia.retencionIva10 = this.retencionIva10;
        copia.retencionIva20 = this.retencionIva20;
        copia.retencionIvaBienes = this.retencionIvaBienes;
        copia.retencionIvaServicios50 = this.retencionIvaServicios50;
        copia.retencionIvaServicios = this.retencionIvaServicios;
        copia.retencionIvaCien = this.retencionIvaCien;
        copia.retencionNCIva = this.retencionNCIva;
        copia.getFormasPago().addAll(this.getFormasPago());
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(ValoresComprobante copiaEdicion) {
        ValoresComprobanteVenta valoresComprobante = (ValoresComprobanteVenta)copiaEdicion;
        this.setBaseNoIva(valoresComprobante.getBaseNoIva());
        this.setBaseIvaNoCero(valoresComprobante.getBaseIvaNoCero());
        this.setMontoIva(valoresComprobante.getMontoIva());
        this.setRetencionIvaBienes(valoresComprobante.getRetencionIvaBienes());
        this.setRetencionIvaServicios(valoresComprobante.getRetencionIvaServicios());
        this.setRetencionIvaCien(valoresComprobante.getRetencionIvaCien());
        this.setBaseExcentaIva(valoresComprobante.getBaseExcentaIva());
        this.setRetencionIva10(valoresComprobante.getRetencionIva10());
        this.setRetencionIva20(valoresComprobante.getRetencionIva20());
        this.setRetencionIvaServicios50(valoresComprobante.getRetencionIvaServicios50());
        this.setRetencionNCIva(valoresComprobante.getRetencionNCIva());
        this.getFormasPago().clear();
        this.getFormasPago().addAll(valoresComprobante.getFormasPago());
        super.actualizarInformacion(copiaEdicion);
    }

    protected void validacionAnotadaExitosa() {
        this.sumarBasesImponibles(this.getBaseNoIva(), this.getBaseIvaCero(), this.getBaseIvaNoCero(), this.getBaseExcentaIva());
        this.calcularMontoIva();
        this.calcularRetenciones();
        this.sumarMontoFormasPago(this.getBaseNoIva(), this.getBaseIvaCero(), this.getBaseIvaNoCero(), this.getMontoIva(), this.getMontoIce(), this.getBaseExcentaIva());
    }

    public void calcularSumaBasesImponibles() {
        this.sumarBasesImponibles(this.getBaseNoIva(), this.getBaseIvaCero(), this.getBaseIvaNoCero(), this.getBaseExcentaIva());
    }

    private ResultadoValidacion validarMontoIva(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoIva()).compareTo(this.getMontoIvaCalculado()) != 0) {
            return resultado.pasarValidacionAdvertencia(String.format("El valor %s es diferente al valor calculado por el sistema %s", "Monto IVA", this.getMontoIvaCalculado().toString()));
        }
        return resultado;
    }

    private ResultadoValidacion validarRetencionIva10(ResultadoValidacion resultadoValidacion) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultadoValidacion, Util.getBigDecimal(this.getRetencionIva10()), this.retencionIva10Calculado, "Retenci\u00f3n IVA 10% Bienes");
    }

    private ResultadoValidacion validarRetencionIva20(ResultadoValidacion resultadoValidacion) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultadoValidacion, Util.getBigDecimal(this.getRetencionIva20()), this.retencionIva20Calculado, "Retenci\u00f3n IVA 20% Servicios");
    }

    private ResultadoValidacion validarRetencionIva30Bienes(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionIvaBienes()), this.retencionIvaBienesCalculado, "Retenci\u00f3n IVA 30% Bienes");
    }

    private ResultadoValidacion validarRetencionIva50(ResultadoValidacion resultadoValidacion) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultadoValidacion, Util.getBigDecimal(this.getRetencionIvaServicios50()), this.retencionIva50Calculado, "Retenci\u00f3n IVA 50% Servicios");
    }

    private ResultadoValidacion validarRetencionIva70Servicios(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionIvaServicios()), this.retencionIvaServiciosCalculado, "Retenci\u00f3n IVA 70% Servicios");
    }

    private ResultadoValidacion validarRetencionIvaCien(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionIvaCien()), this.retencionIvaCienCalculado, "Retenci\u00f3n IVA 100%");
    }

    private ResultadoValidacion validarRetencionIvaNC(ResultadoValidacion resultado) {
        return Retencion.validarValorDeRetencionCorrespondeAlCalculado(resultado, Util.getBigDecimal(this.getRetencionNCIva()), this.retencionIvaCienCalculado, "Retenci\u00f3n IVA NC");
    }

    private ResultadoValidacion validarTotalRetencionMontoIva(ResultadoValidacion resultado) {
        this.sumarRetenciones(this.getRetencionIvaBienes(), this.getRetencionIvaServicios(), this.getRetencionIvaCien(), this.getRetencionIva10(), this.getRetencionIva20(), this.getRetencionIvaServicios50(), this.getRetencionNCIva());
        if (this.getSumaRetenciones().compareTo(Util.getBigDecimal(this.getMontoIva())) == 1) {
            return resultado.fallarValidacion("La sumatoria de las Retenciones no puede ser mayor al valor Monto IVA");
        }
        return resultado;
    }

    private void calcularRetenciones() {
        this.retencionIvaBienesCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_BIENES_30);
        this.retencionIvaServiciosCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_SERV_70);
        this.retencionIvaCienCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_CIEN);
        this.retencionIva20Calculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RETENCION_IVA_VEINTE);
        this.retencionIva50Calculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RETENCION_IVA_50);
        this.retencionIva10Calculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RETENCION_IVA_DIEZ);
        this.retencionIvaNCCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getMontoIva()), PorcentajeRetencion.RET_IVA_NC);
    }

    private void calcularMontoIva() {
        BigDecimal valorCalculado = Util.getPorcentaje(Util.getBigDecimal(this.getBaseIvaNoCero()), ((Iva)this.getRaizModelo()).getPorcentajeIva());
        this.setMontoIvaCalculado(valorCalculado);
        if (!this.isModificaIva()) {
            this.setMontoIva(String.valueOf(valorCalculado));
        }
    }

    public void agregarFormasPago(FormaPago formaPago) {
        formaPago.setPropietario((ObjetoModelo)this);
        this.formasPago.add(formaPago);
        this.firePropertyChange(CC_FORMAS_PAGO, null, this.formasPago);
    }

    public boolean eliminarFormasPago(FormaPago formaPago) {
        boolean eliminado = this.formasPago.remove((Object)formaPago);
        if (eliminado) {
            this.firePropertyChange(CC_FORMAS_PAGO, null, this.formasPago);
        }
        return eliminado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("baseImponible");
        Element eValor = (Element)valorList.item(0);
        this.setBaseIvaCero(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("montoIce");
        eValor = (Element)valorList.item(0);
        this.setMontoIce(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("baseNoGraIva");
        eValor = (Element)valorList.item(0);
        this.baseNoIva = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseImpGrav");
        eValor = (Element)valorList.item(0);
        this.baseIvaNoCero = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseImpExe");
        eValor = (Element)valorList.item(0);
        this.baseExcentaIva = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName(C_MONTO_IVA);
        eValor = (Element)valorList.item(0);
        this.montoIva = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valRetBien10");
        eValor = (Element)valorList.item(0);
        if (eValor != null) {
            this.retencionIva10 = eValor.getTextContent().trim();
        }
        if ((eValor = (Element)(valorList = elemento.getElementsByTagName("valRetServ20")).item(0)) != null) {
            this.retencionIva20 = eValor.getTextContent().trim();
        }
        valorList = elemento.getElementsByTagName("valorRetBienes");
        eValor = (Element)valorList.item(0);
        this.retencionIvaBienes = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valRetServ50");
        eValor = (Element)valorList.item(0);
        if (eValor != null) {
            this.retencionIvaServicios50 = eValor.getTextContent().trim();
        }
        valorList = elemento.getElementsByTagName("valorRetServicios");
        eValor = (Element)valorList.item(0);
        this.retencionIvaServicios = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valRetServ100");
        eValor = (Element)valorList.item(0);
        this.retencionIvaCien = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("valorRetencionNc");
        eValor = (Element)valorList.item(0);
        if (eValor != null) {
            this.retencionNCIva = eValor.getTextContent().trim();
        }
        valorList = elemento.getElementsByTagName("formaPago");
        int i = 0;
        while (i < valorList.getLength()) {
            Node nodo = valorList.item(i);
            if (nodo.getNodeType() == 1) {
                Element elem = (Element)nodo;
                FormaPago formaPago = new FormaPago();
                formaPago.importar(elem, null);
                this.agregarFormasPago(formaPago);
            }
            ++i;
        }
        return this;
    }

    public String getBaseNoIva() {
        return this.baseNoIva;
    }

    public List<FormaPago> getFormasPago() {
        return this.formasPago;
    }

    public String getBaseIvaNoCero() {
        return this.baseIvaNoCero;
    }

    public String getRetencionIvaBienes() {
        return this.retencionIvaBienes;
    }

    public String getRetencionIvaServicios() {
        return this.retencionIvaServicios;
    }

    public String getRetencionIvaCien() {
        return this.retencionIvaCien;
    }

    public String getMontoIva() {
        return this.montoIva;
    }

    public String getBaseExcentaIva() {
        return this.baseExcentaIva;
    }

    public String getRetencionIva10() {
        return this.retencionIva10;
    }

    public String getRetencionIva20() {
        return this.retencionIva20;
    }

    public String getRetencionIvaServicios50() {
        return this.retencionIvaServicios50;
    }

    public void setRetencionIvaServicios50(String retencionIvaServicios50) {
        String oldValue = this.retencionIvaServicios50;
        this.retencionIvaServicios50 = retencionIvaServicios50;
        this.firePropertyChange(RETENCION_IVA_SERVICIOS50, oldValue, this.retencionIvaServicios50);
    }

    public void setBaseNoIva(String baseNoIva) {
        String oldValue = this.baseNoIva;
        this.baseNoIva = baseNoIva;
        this.firePropertyChange(C_BASE_NO_IVA, oldValue, this.baseNoIva);
    }

    public void setBaseIvaNoCero(String baseIvaNoCero) {
        String oldValue = this.baseIvaNoCero;
        this.baseIvaNoCero = baseIvaNoCero;
        this.firePropertyChange(C_BASE_IVA_NO_CERO, oldValue, this.baseIvaNoCero);
    }

    public void setMontoIva(String montoIva) {
        String oldValue = this.montoIva;
        this.montoIva = montoIva;
        this.firePropertyChange(C_MONTO_IVA, oldValue, this.montoIva);
    }

    public void setRetencionIva10(String retencionIva10) {
        String oldValue = this.retencionIva10;
        this.retencionIva10 = retencionIva10;
        this.firePropertyChange(RETENCION_IVA_10, oldValue, this.retencionIva10);
    }

    public void setRetencionIva20(String retencionIva20) {
        String oldValue = this.retencionIva20;
        this.retencionIva20 = retencionIva20;
        this.firePropertyChange(RETENCION_IVA_20, oldValue, this.retencionIva20);
    }

    public void setRetencionIvaBienes(String retencionIvaBienes) {
        String oldValue = this.retencionIvaBienes;
        this.retencionIvaBienes = retencionIvaBienes;
        this.firePropertyChange(C_RET_IVA_BIENES, oldValue, this.retencionIvaBienes);
    }

    public void setRetencionIvaServicios(String retencionIvaServicios) {
        String oldValue = this.retencionIvaServicios;
        this.retencionIvaServicios = retencionIvaServicios;
        this.firePropertyChange(C_RET_IVA_SERVICIOS, oldValue, this.retencionIvaServicios);
    }

    public void setRetencionIvaCien(String retencionIvaCien) {
        String oldValue = this.retencionIvaCien;
        this.retencionIvaCien = retencionIvaCien;
        this.firePropertyChange(C_RET_IVA_CIEN, oldValue, this.retencionIvaCien);
    }

    public void setBaseExcentaIva(String baseExcentaIva) {
        String oldValue = this.baseExcentaIva;
        this.baseExcentaIva = baseExcentaIva;
        this.firePropertyChange(C_BASE_EXCENTA_IVA, oldValue, this.baseExcentaIva);
    }

    public String getRetencionNCIva() {
        return this.retencionNCIva;
    }

    public void setRetencionNCIva(String retencionNCIva) {
        String oldValue = this.retencionNCIva;
        this.retencionNCIva = retencionNCIva;
        this.firePropertyChange(C_BASE_EXCENTA_IVA, oldValue, this.retencionNCIva);
    }

    public boolean isModificaIva() {
        return this.modificaIva;
    }

    public void setModificaIva(boolean modificaIva) {
        this.modificaIva = modificaIva;
    }
}

